'##############################################################
'Feuchtigkeitssensor_HYT271.bas
'
'
'Das Programm liest einen Temperatur und Feuchtigkeitssensor vom Typ HYT271
'oder Typ HYT939 ber I2C aus und gibt die Werte ber RS232 aus
'
'Wenn ein USB Modul an RN-AVR UNIVERSAL angesteckt oder eingeltet wurde
'dann wird das Ergebnis  ber USB zu einem virtuellen COM Port bertragen
'und kann auch mit allen Programmen oder Terminalprogramm empfangen werden
'
'
' (c) Frank roboternetz.de
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################



Declare Function HYT_Test() As Integer
Declare Function HYT_Auslesen() As Integer
Declare Sub HYT_WerteAusgeben()



$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$prog &HFF , &HFF , &HD9 , &HFE                             'Fusebits richtig programmieren (Quarz ein,Jtag aus)

$regfile = "m644pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 8000000                                          'Quarzfrequenz

$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800

Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1





Config Pind.6 = Output                                      'LED
Led1 Alias Portd.6


dim e as integer
'Globale Werte die ausgelesen wurden
Dim feuchtigkeit As Single
Dim temperatur As Single



'Slave Adresse definieren
Const Hyt_Addr_w = &H50    '50 enspricht der 7 Slave Addr 28 laut Datenblatt
Const Hyt_Addr_r = &H51


'Hauptprogramm
I2cinit
e=HYT_Test()

Do
   e=HYT_Auslesen()
   HYT_WerteAusgeben
   Wait 4
Loop




'Hilfsfunktionen

'HYT-Sensor auslesen, temperatur und Feuchtigkeit in Variablen eintragen
Function HYT_Auslesen() As Integer
local status As Byte
local a1 As Word
local a2 As Word
local Lbyte1 As Byte
local Hbyte1 As Byte
local Lbyte2 As Byte
local Hbyte2 As Byte

   'Messvorgang starten
   I2cstart
   I2cwbyte Hyt_Addr_w
   I2cstop


  'auf abgeschlossenen Messvorgang warten
   Do
      Waitms 60
      Err = 0
      I2cstart
      I2cwbyte Hyt_Addr_r
      I2crbyte Hbyte1 , Ack
      status = Hbyte1 And &HC0
      Shift status , Right , 6
      If status = 0 Then Exit Do
      I2cstop
   Loop

   'Restlichen 3 Werte auslesen
   I2crbyte Lbyte1 , Ack
   I2crbyte Hbyte2 , Ack
   I2crbyte Lbyte2 , Nack
   I2cstop

   'Umrechnung
   '
   'Luftfeuchte
   Hbyte1 = Hbyte1 And &H3F   'Status-Bits loeschen
   A1 = Hbyte1
   Shift A1 , Left , 8
   A1 = A1 Or Lbyte1
   feuchtigkeit = A1 / 163.84

   '
   'Temperatur
   A2 = Hbyte2
   Shift A2 , Left , 8
   Lbyte2 = Lbyte2 And &HFC
   A2 = A2 Or Lbyte2
   temperatur = A2
   temperatur = temperatur / 65536
   temperatur = temperatur * 165
   temperatur = temperatur - 40
end function


Sub HYT_WerteAusgeben() As Integer
local tbuffer As String * 8
local fbuffer As String * 8

   tbuffer = Fusing(temperatur , "#.#")
   fbuffer = Fusing(feuchtigkeit , "#.#")
   print "Messwerte ermittelt ueber RN-AvrUniversal (c)Robotikhardware.de  und HYT Sensor"
   Print "Temperatur: " ;tbuffer ;  " C" ; "  Feuchtigkeit:" ; fbuffer ; " %"
end sub


'Test ob Sensor auf I2C reagiert
'Rueckgabe 0=Sensor nicht vorhanden 1=Sensor vorhanden
Function HYT_Test() As Integer
   I2cstart
   I2cwbyte Hyt_Addr_w
   If Err = 0 Then
       Print "HYT Sensor OK!"
      HYT_Test =1
   Else
       Print "HYT Sensor nicht vorhanden!"
       HYT_Test=0
   End If
   I2cstop
end function